 ; Ŀ
 ;   Pn - plot using a page setup.                                         
 ;   Copyright 2001, 2002, 2003, 2004, 2010 by Rocket Software Ltd.        
 ;                                                                         
 ; 

 ; Ŀ
 ;   Fisp - find out which space the title block occupies.                 
 ;   Takes no arguments, returns either "Model" or "Paper", indicating     
 ;   the space to plot.                                                    
 ;   Revised 2010.02.18: may also return None if no tb is found.           
 ;   Contains an internal list of blocks, if any one is found in the       
 ;   drawing then the space it occupies is taken as the one to plot.       
 ;   No provision is made for choosing between multiple paper space        
 ;   layouts.                                                              
 ; 
 (DEFUN FISP (/ tblist blnam ss enam space prisp)
  (setq tblist '("icaltblk" "d-bord-e" "TRIDYNE_TB_D" "gca1tb" "geielctb"
                 "Husky_A1" "a1b" "D-GEN-L" "T2A-3" "IFCDATE1" "IFCDATE2"
                 "IFCDATE3" "IFCDATE4" "horz_2dborda1" "Marathontb"
                 "RWTitleBlock" "PPC-Dsize"))
  (while (and (setq blnam (car tblist))
              (or (null (tblsearch "block" blnam))
                  (null (setq ss (ssget "x" (list (cons 2 blnam)))))))
         (setq tblist (cdr tblist)))
  (cond ((null ss)
         (setq prisp "None"))
        ((and (setq enam (ssname ss 0))
              (setq space (cdr (assoc 67 (entget enam))))
              (= space 1))
         (setq prisp "Paper"))
        (T
         (setq prisp "Model")))
 prisp)
 ; Ŀ
 ;   Fisp end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Pase: plot with a page setup.                              
 ;   Arguments: Printa, the printer pc3 file name.                         
 ;              Layo, layout name.                                         
 ;   Calls nothing, Returns nothing.                                       
 ; 
 (DEFUN PASE (printa layo)
  (command "plot")                     ; fairly self-evident
  (command "n")                        ; detailed plot configuration?
  (command "layout1")                  ; layout name or [?] <Layout1>
  (command "cve-lay-may-7500-layout")  ; page setup name <>: 
  (command "bw_ricoh_mpc7500")         ; output device name or [?] <G006.pc3>:
  (command "N")                        ; plot to a file?
  (command "")                         ; Save changes to page setup [Yes/No]?
  (command "Y")                        ; Proceed with plot?
 (princ))
 ; Ŀ
 ;   Subroutine Pase end.                                                  
 ; 

 ; Ŀ
 ;   Pn.                                                                   
 ; 
 (DEFUN C:PN (/ spac)
  (setvar "cmdecho" 1)
  (setq spac (fisp))
  (cond ((= "Model" spac)
         (setvar "tilemode" 1))
        ((= "Paper" spac)
         (setvar "tilemode" 0)))
  (pase "printer" "layout name")
 (princ))